% Skript buck_down1.m, in dem das Modell
% buck_down_1.mdl initialisiert und aufgerufen wird
clear;
% -------- Parameter der Schaltung
R = 5;          L = 0.001;     C = 100e-6;
Ui = 5;
f0 = 0.2e5;    T = 1/f0;      T2 = T/2;
Rmax = 2*L/T2,
R = 2*Rmax,
%R = 0.1*Rmax,

% -------- Aufruf der Simulation
Tfinal = 0.5
dt = 0.5e-6;
sim('buck_down_1',[0:dt:Tfinal]);
t = y.time;
iL = y.signals.values(:,1);
u0 = y.signals.values(:,2);

figure(1);     clf;
n = length(t);
subplot(211), plot(t, iL);
axis tight;  grid on;
title('Strom der Induktivitt iL(t)');
xlabel('Zeit in s');
subplot(212), plot(t, u0);
axis tight;  grid on;
title('Spannung der Kapazitt u0(t)');
xlabel('Zeit in s');

figure(2);     clf;
nd = n-1000;
subplot(211), plot(t(nd:end), iL(nd:end));
axis tight;  grid on;
title('Strom der Induktivitt iL(t) (Ausschnitt)');
xlabel('Zeit in s');
subplot(212), plot(t(nd:end), u0(nd:end));
axis tight;  grid on;
title('Spannung der Kapazitt u0(t) (Ausschnitt)');
xlabel('Zeit in s');
