% Skript buck_boost2.m, in dem das Modell
% buck_boost_2.mdl initialisiert und aufgerufen wird
clear;
% -------- Parameter der Schaltung
R = 5;           L = 0.001;     C = 200e-6;
Ui = 5;
f0 = 0.2e5;      T = 1/f0;      T2 = T*0.8;
T1 = T-T2;
Rmax = (T1+T2)*2*L/(T2^2),
% -------- Aufruf der Simulation
Tfinal = 0.025,
dt = 0.5e-6;
sim('buck_boost_2',[0:dt:Tfinal]);
t = y.time;
iL = y.signals.values(:,1);
u0 = y.signals.values(:,2);
iD = y.signals.values(:,3);
iC = y.signals.values(:,4);

figure(1);     clf;
n = length(t);
subplot(411), plot(t, iL);
axis tight;  grid on;
title('Strom der Induktivitt iL(t)');
xlabel('Zeit in s');
subplot(412), plot(t, u0);
axis tight;  grid on;
title('Spannung der Kapazitt u0(t)');
xlabel('Zeit in s');
subplot(413), plot(t, iD);
axis tight;  grid on;
title('Strom der Diode iD(t)');
xlabel('Zeit in s');
subplot(414), plot(t, iC);
axis tight;  grid on;
title('Strom der Kapazitt iC(t)');
xlabel('Zeit in s');

figure(2);     clf;
nd = n-1000;
subplot(411), plot(t(nd:end), iL(nd:end));
axis tight;  grid on;
title('Strom der Induktivitt iL(t) (Ausschnitt)');
xlabel('Zeit in s');
subplot(412), plot(t(nd:end), u0(nd:end));
axis tight;  grid on;
title('Spannung der Kapazitt u0(t) (Ausschnitt)');
xlabel('Zeit in s');
subplot(413), plot(t(nd:end), iD(nd:end));
axis tight;  grid on;
title('Strom der Diode iD(t)');
xlabel('Zeit in s');  La = axis;
axis([La(1:2), -0.05, La(4)]);
hold on;    nD = fix(length(iD)/2);  
Im = mean(iD(nD:end));
plot([La(1:2)], [Im, Im], 'r');     hold off;
text(Tfinal*0.995, Im*0.9, 'Im');
subplot(414), plot(t(nd:end), iC(nd:end));
axis tight;  grid on;
title('Strom der Kapazitt iC(t)');
xlabel('Zeit in s');  La = axis;
axis([La(1:2), La(3)*1.2, La(4)*1.2]);

% ------- Geschtzte Grenzwerte I1 und I2
I1 = Ui*(T1+T2)*T1/(T2^2*R)-Ui*T1/(2*L),
I2 = Ui*(T1+T2)*T1/(T2^2*R)+Ui*T1/(2*L),
U0 = -Ui*T1/T2,
