% Skript TP_1.m, in dem FIR- und IIR-TP-Filter
% untersucht werden.
clear;
% ------- FIR-Filter
nord = 512;    % Ordnung des Filters
L = 100;       % Dezimierungsfaktor (1/(2L) = Durchlassfreq.)
h = fir1(nord, 2*(1/(2*L)));    % Impulsantwort (Koeffizienten)
figure(1);   clf;
stem(0:nord, h);
title('Impulsantwort des FIR-Filters');
xlabel('n');   grid on;
% Frequenzgang
N = 1024;
nd = fix(N/10)
[H, w] = freqz(h,1,N);
figure(2);   clf;
subplot(211), plot(w(1:nd)/(2*pi), 20*log10(abs(H(1:nd))));
title('Amplitudengang des FIR-TP-Filters');
xlabel('Relative Frequenz');   grid on;
subplot(212), plot(w(1:nd)/(2*pi), unwrap(angle(H(1:nd))));
title('Phasengang des FIR-TP-Filters');
xlabel('Relative Frequenz');   grid on;
% ------- IIR-Filter
nord = 6;      % Ordnung des Filters
L = 100;       % Dezimierungsfaktor (1/(2L) = Durchlassfreq.)
[b,a] = butter(nord, 1/L); % Impulsantwort des IIR-Filters
%[b,a] = cheby1(nord, 0.5, 1/L); % Impulsantwort des IIR-Filters
figure(3);   clf;
h = filter(b, a, [1, zeros(1,1000)]);  % Impulsantwort
stem(0:length(h)-1, h);
title('Impulsantwort des IIR-Filters');
xlabel('n');   grid on;
% Frequenzgang
N = 2048;
nd = fix(N/10)
[H, w] = freqz(b,a,N);
figure(4);   clf;
subplot(211), plot(w(1:nd)/(2*pi), 20*log10(abs(H(1:nd))));
title('Amplitudengang des IIR-TP-Filters');
xlabel('Relative Frequenz');   grid on;
subplot(212), plot(w(1:nd)/(2*pi), unwrap(angle(H(1:nd))));
title('Phasengang des IIR-TP-Filters');
xlabel('Relative Frequenz');   grid on;
