% Skript wurf_12.m, in dem die Frderung mit Mikrowrfen
% untersucht wird
clear;
% ------- Parameter des Systems
g = 9.89;
% ------- Anregungsbewegung
ampl = 0.04;     % Amplitude der Anregungsbewegung
fanr = 4;      % Frequenz der Anregungsbewegung
% ------- Simulation mit Euler-Verfahren
Tfinal = 5;
dt = 0.0001;
t = 0:dt:Tfinal;    nt = length(t);
% Initialisierungen
z = ampl*cos(2*pi*fanr*t);
vz = -ampl*2*pi*fanr*sin(2*pi*fanr*t);
az = -ampl*(2*pi*fanr)^2*cos(2*pi*fanr*t);
beta = pi/4;
x = z*cos(beta);      y = z*sin(beta);
vx = vz*cos(beta);    vy = vz*sin(beta);
ax = az*cos(beta);    ay = az*sin(beta);
% Initialisierungen
xx = zeros(1,nt);     yy = xx;
vxx = xx;             vyy = xx;
dxx = xx;
v_temp = vx(1);
x_temp = 0;
for k = 1:nt-1
if  ay(k) > - g & yy(k) <= y(k);  % Haftung
        vyy(k+1) = vy(k);
        vxx(k+1) = vx(k+1);
        yy(k+1)  = y(k+1);
        xx(k+1)  = x(k+1);        
        v_temp = vx(k+1);
    elseif yy(k) < y(k);     
        vyy(k+1) = vy(k);
        vxx(k+1) = vx(k+1);
        yy(k+1)  = y(k+1);
        xx(k+1)  = x(k+1);
        v_temp = vx(k+1);     
    else 
        vyy(k+1) = vyy(k) + dt*(-g);  % Wurf
        yy(k+1)  = yy(k) + dt*vyy(k+1);
        xx(k+1) =  xx(k) + dt*(v_temp);
    end;
end;

figure(1);    clf;
nperioden = 5;
Tnperioden = 5/fanr;     nT = fix(Tnperioden/dt);
nd = nt - nT:nt;         % Darstellungen von 5 Perioden im
                         % stationren Zustand
% nd = 1:nt;             % Darstellung mit Einschwingen
subplot(311), plot(t(nd), vx(nd)*10, t(nd), ay(nd),'r',t(nd), 100*x(nd));
title(['Geschwindigkeit*10 in x Richtung; Vertikale Beschleunigung'...
    '  und Lage des Frderorgans in x Richtung',...
    '  (fanr = ',num2str(fanr),'  Hz)']);    
xlabel('Zeit in s');      grid on;   hold on;
axis tight;
La = axis;    plot([La(1), La(2)], [-g, -g],'r');
hold off;

subplot(312), plot(t(nd), y(nd), t(nd), yy(nd));
title('Vertikale Bewegung des Frderorgans und vertikale Bahn des Wurfes')
xlabel('Zeit in s');        grid on;      
legend('y', 'yy');     axis tight;

subplot(313), plot(t(nd), xx(nd));
title('Bewegung des Frderguts')
xlabel('Zeit in s');        grid on;      
axis tight;
   

