% Skript wurf_1.m, in dem der Wurf einer kleinen Masse
% von einer groen schwingeneden Masse untersucht wird
clear;

% ------- Parameter des Systems
m1 = 5;     c1 = 5;     k1 = 5;
m2 = 1;   % Masse die ''geworfen'' wird
g = 9.89;
% ------- Anregungsbewegung
ampl = 0.05;     % Amplitude der Anregungsbewegung
fanr = 5;      % Frequenz der Anregungsbewegung
% ------- Simulation mit Euler-Verfahren
Tfinal = 100;
dt = 0.0001;
t = 0:dt:Tfinal;    nt = length(t);
% Initialisierungen
y = zeros(1,nt);    vy = y;      ay = y;
x = ampl*cos(2*pi*fanr*t);
vx = -ampl*2*pi*fanr*sin(2*pi*fanr*t);
ax = -ampl*(2*pi*fanr)^2*cos(2*pi*fanr*t);
for k = 1:nt-1
    if  ax(k) > - g & y(k) <= x(k)
        vy(k+1) = vx(k);
        y(k+1)  = x(k);
    elseif y(k) < x(k);     
        vy(k+1) = vx(k+1);
        y(k+1)  = x(k+1); 
    elseif y(k) >= x(k);
        vy(k+1) = vy(k) + dt*(-g);
        y(k+1)  = y(k) + dt*vy(k+1);
    else
        vy(k+1) = vy(k) + dt*(-g);
        y(k+1)  = y(k) + dt*vy(k+1);
    end;
end;

figure(1);    clf;
nperioden = 5;
Tnperioden = 5/fanr;     nT = fix(Tnperioden/dt);
nd = nt - nT:nt;         % Darstellungen von 5 Perioden im
                         % stationren Zustand
% nd = 1:nt;             % Darstellung mit Einschwingen
subplot(211), plot(t(nd), vx(nd)*10, t(nd), ax(nd),'r');
title(['Geschwindigkeit*10 und Beschleunigung; Frequenz der',...
    'Anregung    fanr = ',num2str(fanr),'  Hz']);    
xlabel('Zeit in s');      grid on;   hold on;
axis tight;
La = axis;    plot([La(1), La(2)], [-g, -g],'r');
hold off;
subplot(212), plot(t(nd), x(nd), t(nd), y(nd));
title('Lage der Masse 1 und der Masse 2')
xlabel('Zeit in s');        grid on;      
legend('x', 'y');     axis tight;
   

