% Skript unwucht_3.m, in dem die Schwingungen durch Unwucht
% eines Feder-Masse-System mit Tilger untersucht werden
% Arbeitet mit Modell unwucht3.slx
clear;
s = tf('s');
% ------- Parameter des Systems
m = 10;   m0 = 1;
k = 10;   c = 5;    cT = 0.0001;
e = 0.2;
% ------- Eigene Frequenz ohne Daempfung
omega_0 = sqrt(k/(m+m0));
f_0 = omega_0/(2*pi);
% ------- Frequenz der Anregung
%omega = 0.5*omega_0;
%omega = 5*omega_0;
omega = omega_0;
f = omega/(2*pi);
% ------- Parameter des Tilgers (angepasst an omega)
kT = 5,          
mT = kT/(omega)^2,      % Angepasster Tilger
%mT = 0.9*kT/(omega)^2,   % Nicht ganz angepasster Tilger

% ------- Matrizen des Systems
Ai = [(m+m0)*s^2+(c+cT)*s+(k+kT), -cT*s-kT; -cT*s-kT, mT*s^2+cT*s+kT];
Bi = [1, 0]';
HT = inv(Ai)*Bi;

[b1T,a1T] = tfdata(HT(1));
b1T = b1T{:};       % Koeffizienten der Uebertragungsfunktion 
a1T = a1T{:};

[b2T,a2T] = tfdata(HT(2));
b2T = b2T{:};       % Koeffizienten der Uebertragungsfunktion 
a2T = a2T{:};
% ------- Aufruf der Simulation
Tfinal = 200;
my_options = simset('MaxStep', 2);
sim('unwucht3', [0, Tfinal], my_options);

t = x.time;
x = x.signals.values;
xT = xT.signals.values;

figure(1);    clf;
subplot(211), plot(t, x);
title('Schwingung der Lage der Hauptmasse');
xlabel('Zeit in s');    grid on;

subplot(212), plot(t, xT);
title('Schwingung der Lage der Tilgungsmasse');
xlabel('Zeit in s');    grid on;


















