% Skript unwucht_1.m, in dem die Amplitude
% der Bewegung der Hauptmasse abhngig von omega
% untersucht wird

clear;
% ------- Parameter des Systems
m = 10;   m0 = 1;
k = 10;   c = 5;    
e = 0.2;
% -------- Amplitude x
omega_0 = sqrt(k/(m+m0));  % Eigenfrequenz ohne Dmpfung 
f_0 = omega_0/(2*pi);

fmin = f_0/100;              fmax = f_0*100;
a1 = round(log10(fmin));     a2 = round(log10(fmax));
f = logspace(a1, a2, 1000);
omega = (2*pi)*f;
ampl_x = m0*(omega.^2)*e./sqrt((k-(m+m0)*(omega.^2)).^2 +...
    (c*omega).^2);
%###########################
figure(1);    clf;
subplot(211), loglog(f, ampl_x);
title('Amplitude x (logarithmisch)');
xlabel('Hz');    grid on;      ylabel('log10( ampl-x )');    hold on;
La = axis;    loglog([f_0, f_0], [La(3), La(4)], 'r');
hold off;
subplot(212), semilogx(f, ampl_x);
title('Amplitude x (linear)');
xlabel('Hz');    grid on;      ylabel('ampl-x');    hold on;
La = axis;    loglog([f_0, f_0], [La(3), La(4)], 'r');
hold off;