% Skript tilger_gleitreib2.m, in dem ein Tilger
% mit Gleitreibung untersucht wird.
% Arbeitet mit Modell tilger_gleitreib_2.mdl

clear;
% -------- Parameter des Systems
m = 100;   k = 5000;    c = 1;
rg = 100;
%rg = 0;
mT = 0.2*m;   % Angepasster Tilger
kT = k*mT/m,
%e = 1e-3;   f = rg;    % Fr Dahl-Modell
sigma_0 = 1e3;
sigma_1 = sqrt(sigma_0);
sigma_2 = 0;
vs = 0.1;
FG = 1.0;
FH = 2.0;
%###########
v0 = 0.5;
x0 = 0.0;
v0T = 0;    x0T = 0;
% -------- Aufruf er Simulation
Tfinal = 100;
dt = 0.001;      ts = [0,Tfinal];
my_options = simset('solver','ode2','FixedStep',dt);
sim('tilger_gleitreib_2',ts,my_options);

x  = y.signals.values(:,1);
xT = y.signals.values(:,2);
t = y.time;

figure(1);   clf; %############
subplot(211), plot(t,x);

subplot(212), plot(t,xT);

Q = sum(x.^2),     % Gtekriterium

% -------- Spektrum
nfft = length(x);
X = fft(x)/nfft;
nd = 1:fix(nfft/100);
figure(2);   clf; %############
plot((nd-1)/(nfft*dt), 20*log10(abs(X(nd))));
grid on;