% Skript suspension_4.m, in dem ein vereinfachtes Modell
% eines Fahrzeugs simuliert wird
clear;
s = tf('s');
% ------- Parameter des Systems
ms = 300;   % kg
ma = 25;    % kg
I = 225;    % kg m^2
L = 3;      % m
a = 1.7;    % m
c = 1200;     % N s/m
ct = 5000;    % N s/m
k = 12000;    % N/m
kt = 100000;  % N/m
% ------- Matrizen des Modells
M = [I 0 0 0;0 ms 0 0;0 0 ma 0;0 0 0 ma];
C = [c*(a^2 + (L-a)^2) c*L -c*a c*(L-a);
    c*(L-2*a) 2*c -c -c;
    -c*a -c c+ct 0; 
    c*(L-a) -c 0 c+ct];
K = [k*(a^2+(L-a)^2) k*L -k*a k*(L-a);
    k*(L-2*a) 2*k -k -k;
    -k*a -k k+kt 0;
    k*(L-a) -k 0 k+kt];
% -------- bertragungsfunktionen von Y und Z zu X
Pyz = [0,0;0,0;ct*s+kt,0;0,ct*s+kt];  % Anregngen [Y(s); Z{s)]
Hyz = inv(s^2*M + s*C + K)*Pyz; % bertragungsfunktion-Matrix 
% -------- Sprungantworten
Tfinal = 2;
my_sys = tf(Hyz);
[xstep_yz, t] = step(my_sys, Tfinal);

figure(1);    clf;
subplot(211), plot(t, [xstep_yz(:,:,1)]);
title('Sprungantworten von y(t) bis zu den Variablen x(t)')
xlabel('Zeit in s');     grid on;   
legend('\theta(t)', 'x1(t)','x2(t)','x3(t)');
subplot(212), plot(t, [xstep_yz(:,:,2)]);
title('Sprungantworten von z(t) bis zu den Variablen x(t)')
xlabel('Zeit in s');     grid on;
legend('\theta(t)', 'x1(t)','x2(t)','x3(t)');
% -------- Frequenzgnge mit bode
f = logspace(-1, 2, 500);
[betrag, phase] = bode(my_sys,2*pi*f);  % Betrge und Phasen von 2 Eingngen 
                                        % zu vier Ausgngen
betrag_yx = betrag(:,1,:);              % Betrge und Phasen vom y Eingang
phase_yx = phase(:,1,:);
betrag_zx = betrag(:,2,:);              % Betrge und Phasen vom z Eingang
phase_zx = phase(:,2,:);

figure(2);    clf;
subplot(211), semilogx(f, squeeze(20*log10(betrag_yx)));
title('Amplitudengnge vom Eingang y zu allen x Ausgngen');
xlabel('Hz');   grid on;   ylabel('dB');
subplot(212), semilogx(f, squeeze(phase_yx));
title('Phasengnge vom Eingang y zu allen x Ausgngen');
xlabel('Hz');   grid on;   ylabel('Grad');

figure(3);    clf;
subplot(211), semilogx(f, squeeze(20*log10(betrag_zx)));
title('Amplitudengnge vom Eingang y zu allen x Ausgngen');
xlabel('Hz');   grid on;   ylabel('dB');
subplot(212), semilogx(f, squeeze(phase_zx));
title('Phasengnge vom Eingang y zu allen x Ausgngen');
xlabel('Hz');   grid on;   ylabel('Grad');













