function [x] = slip_stick_31;
% Skript slip_stick_31.m in dem ein Slip-Stick
% System simuliert wird
global FG FH vstr m k c vb 
% ------- Parameter des Systems
m = 10;     k = 10;     c = 0.1;
FH = 12;        % Haftreibungskraft
FG = 10;        % Gleitreibungskraft
vstr = 0.1;     % Stribeck Geschwindigkeit
vb = 0.1;       % Bandgeschwindigkeit

% ------- Simulation mit ode-Verfahren
Tfinal = 100;           dt = 0.001;
t = 0:dt:Tfinal-dt;     nt = length(t)

x0 = 0.1;   v0 = 0.05;
%[t,x] = ode45(@ableitungen, t, [x0,v0]);
%[t,x] = ode23(@ableitungen, t, [x0,v0]);
[t,x] = ode113(@ableitungen, t, [x0,v0]);
%x = ode4(@ableitungen, t, [x0,v0]);
%x = ode2(@ableitungen, t, [x0,v0]);

figure(1);    clf;
plot(t, x(:,2)-vb, t, x(:,1));
title('Relative Geschwindigkeit (vy - vb) und Lage'); 
xlabel('s');     grid on;

%#################################
function ya = ableitungen(t,x),
global FG FH vstr m k c vb 
ya = zeros(2,1);         % Die Ableitungen initialisieren
Fe = k*x(1);             % Aktive Kraft
Fstr = (FG + (FH-FG)*exp(-abs(x(2)-vb)/vstr))*sign(x(2)-vb);
ya(1) = x(2);
ya(2) = (-Fe - Fstr - c*x(2))/m;




