% Skript slip_stick_31.m in dem ein System mit 
% Slip-Stick-Verhalten untersucht wird. Es wird
% Stribeck-Kennlinie fr die Reibungskraft benutzt.
% Arbeitet mit Modell slip_stick31.mdl
clear;
% -------- Parameter des Systems
m = 10;      k = 10;   % Masse und Federkonstante
c = 0;                 % Viskose Dmpfungskoeffizient
% c = 0.1;
vb = 0.1;              % Bandgeschwindigkeit
FG = 10;               % Gleitreibung 
FH = 12;               % Haftreibung 
vs = 0.05;             % Stribeck-Geschwindigkeit
% -------- Aufruf der Simulation
Tfinal = 100;
dt = 0.001;      ts = [0,Tfinal];
my_options = simset('solver','ode4','FixedStep',dt);
%my_options = simset('solver','ode45','MaxStep',dt);

sim('slip_stick31',ts,my_options);
vy  = y.signals.values(:,1);   % Geschwindigkeit der Masse
yl = y.signals.values(:,2);    % Lage der Masse
vrel = y.signals.values(:,3);  % Relative Geschwindigkeit
Fk = y.signals.values(:,4);    % Federkraft
Fr = y.signals.values(:,5);    % -Reibkraft
t =  y.time;                   % Simulationszeit

figure(1);   clf;
a(1) = subplot(311),  plot(t, yl);
title('Koordinate der Lage der Masse');
grid on;     xlabel('Zeit in s');
a(2) = subplot(312),  plot(t, vrel);
title('Relative Geschwindigkeit vy - vb');
grid on;     xlabel('Zeit in s');
La = axis;   axis([La(1:3), 0.1*max(abs(La(3)))])
a(3) = subplot(313),  plot(t, Fk, t, Fr);
title('Federkraft und - Reibungskraft');
grid on;     xlabel('Zeit in s');
linkaxes(a,'x');