% Skript slip_stick_21.m in dem ein System mit 
% Slip-Stick-Verhalten untersucht wird. Es wird
% das LuGre-Modell fr die Reibungskraft benutzt.
% Arbeitet mit Modell slip_stick21.mdl
clear;
% -------- Parameter des Systems
m = 10;      k = 10;   % Masse und Federkonstante
c = 0;                 % Viskose Dmpfungskoeffizient
% c = 0.1;
vz = 0.1;              % Bandgeschwindigkeit
FG = 10;               % LuGre-Modell Parameter
FH = 12;
sigma_0 = 1e4;
sigma_1 = sqrt(1e5);
sigma_2 = c;
vs = 0.05;             % Stribeck-Geschwindigkeit
% -------- Aufruf der Simulation
Tfinal = 100;
dt = 0.001;      ts = [0,Tfinal];
my_options = simset('solver','ode4','FixedStep',dt);
%my_options = simset('solver','ode45','MaxStep',dt);

sim('slip_stick21',ts,my_options);
vy  = y.signals.values(:,1);   % Geschwindigkeit der Masse
yl = y.signals.values(:,2);    % Lage der Masse
z = y.signals.values(:,3);     % Ziehlage
Fk = y.signals.values(:,4);    % Federkraft
Fr = y.signals.values(:,5);    % -Reibungskraft
t = y.time;                    % Simulationszeit

figure(1);   clf;
a(1) = subplot(311),  plot(t, yl, t, z);
title('Koordinate der Lage der Masse und die Ziehlage');
grid on;     xlabel('Zeit in s');
a(2) = subplot(312),  plot(t, vy);
title('Geschwindigkeit der Masse');
grid on;     xlabel('Zeit in s');
a(3) = subplot(313),  plot(t, Fk, t, Fr);
title('Federkraft und - Reibungskraft');
grid on;     xlabel('Zeit in s');
linkaxes(a,'x');