% Skript rad_aufhaeng_2.m, in dem die Radaufhngung
% eines Fahrzeugs simuliert wird
clear;
% ------- Parameter des Systems
ms = 200;   c = 100;     k = 12000;
ma = 25;    ct = 100;    kt = 10000;

% ------- Matrizen des systems
M = [ms 0;0 ma];   C = [c -c;-c ct+c];   K = [k -k; -k kt+k];
% ------- Poly-Eigenwerte
[X,e] = polyeig(K, C, M);
[e, k] = sort(e),
X = X(:,k);
f1 = abs(imag(e(1)))/(2*pi),    f2 = abs(imag(e(3)))/(2*pi),

% ------- Homogene Lsung
dt = 0.005;         Tfinal = 2;
t = 0:dt:Tfinal;
p = [0 0 1 1];   % Es wird nur die zweite Eigenfrequenz angeregt
%p = [1 1 0 0];   % Es wird nur die erste Eigenfrequenz angeregt 
xv0 = [X(:,1),X(:,2),X(:,3),X(:,4);...
    X(:,1)*e(1),X(:,2)*e(2),X(:,3)*e(3),X(:,4)*e(4)]*p';

x = p(1)*X(:,1)*exp(e(1)*t) + p(2)*X(:,2)*exp(e(2)*t)+...
    p(3)*X(:,3)*exp(e(3)*t) + p(4)*X(:,4)*exp(e(4)*t);
x1 = real(x);           % Die eventuellen kleinen Imaginrteile
                        % wegen numerischen Fehlern entfernen
figure(1);    clf;
plot(t, x1);
title(' Lagen der zwei Massen');    grid on;
xlabel('Zeit in s');     legend('x1', 'x2');

