% Skript rad_aufhaeng_1.m, in dem die Radaufhngung
% eines Fahrzeugs simuliert wird
clear;
% ------- Parameter des Systems
ms = 200;   c = 1200;     k = 12000;
ma = 25;    ct = 5000;    kt = 100000;
% ------- Matrizen des systems
M = [ms 0;0 ma];   C = [c -c;-c ct+c];   K = [k -k; -k kt+k];
% ------- Poly-Eigenwerte
[X,e] = polyeig(K, C, M);
[e, k] = sort(e),
X = X(:,k);
f1 = abs(imag(e(1)))/(2*pi),    f2 = abs(imag(e(3)))/(2*pi),

% ------- Homogene Lsung
dt = 0.01;         Tfinal = 5;
t = 0:dt:Tfinal;
x0 = [1;0]*1e-2;   v0 = [1;0];   % Anfangsbedingungen

p = inv([X(:,1),X(:,2),X(:,3),X(:,4);...
    X(:,1)*e(1),X(:,2)*e(2),X(:,3)*e(3),X(:,4)*e(4)])*[x0;v0];

x = p(1)*X(:,1)*exp(e(1)*t) + p(2)*X(:,2)*exp(e(2)*t)+...
    p(3)*X(:,3)*exp(e(3)*t) + p(4)*X(:,4)*exp(e(4)*t);
x1 = real(x);           % Die eventuellen kleinen Imaginrteile
                        % wegen numerischen Fehlern entfernen
figure(1);    clf;
plot(t, x1);
title(' Lagen der zwei Massen');    grid on;
xlabel('Zeit in s');     legend('x1', 'x2');

