% Skript position_reg_2.m in dem ein System mit 
% Slip-Stick-Verhalten untersucht wird. Es wird
% das LuGre-Modell fr die Reibungskraft benutzt.
% Arbeitet mit Modell position_reg2.mdl
clear;
% -------- Parameter des Systems
m1 = 1;     g = 9.89;
mu0 = 0.2;         % Gleitreibungskoeffizient
muh = 0.4;         % Haftreibungskoeffizient
FG = m1*g*mu0;     % LuGre-Modell Parameter
FH = m1*g*muh;
sigma_0 = 5000;
sigma_1 = sqrt(sigma_0);
sigma_2 = 0;
vs = 0.05;              % Stribeck-Geschwindigkeit
e = 1e-4;     f = FG;   % Dahl-Modell Parameter
% -------- PID-Regler
P = 10;     I = 20;     D = 10;
% -------- Aufruf der Simulation
Tfinal = 50;
dt = 0.001;      ts = [0,Tfinal];
%my_options = simset('solver','ode4','FixedStep',dt);
my_options = simset('solver','ode45','MaxStep',dt);

sim('position_reg2',ts,my_options);
yl  = y.signals.values(:,1);   % Lage der Masse
vy = y.signals.values(:,2);    % Geschwindigkeit der Masse
Fr = y.signals.values(:,3);    % -Reibungskraft
t = y.time;                    % Simulationszeit

figure(1);   clf;
a(1) = subplot(311),  plot(t, yl);
title('Koordinate der Lage der Masse');
grid on;     xlabel('Zeit in s');
a(2) = subplot(312),  plot(t, vy);
title('Geschwindigkeit der Masse');
grid on;     xlabel('Zeit in s');
a(3) = subplot(313),  plot(t, Fr);
title('Reibungskraft');
grid on;     xlabel('Zeit in s');
linkaxes(a,'x');