% gleichstrom_motor_1.m
clear;

% ------- Parameter des Systems
J = 10;   cj = 10;  km = 10;
L = 1;    R = 0.1;
U = 100;

% ------- Aufruf der Simulation
dt = 0.002;     Tfinal = 150;
t = 0:dt:Tfinal;
my_options = simset('MaxStep', dt);
sim('gleichstrom_motor1', [t], my_options);

%return
t = xy.time;
i = xy.signals.values(:,1);
omega = xy.signals.values(:,2); 
theta = xy.signals.values(:,3);

figure(1);    clf;
subplot(311), plot(t, i);
title(['Strom des Gleichstrommotors']);
xlabel('Zeit in s');    grid on;    

subplot(312), plot(t, omega);
title('Kreisgeschwindigkeit omega');
xlabel('Zeit in s');    grid on;

subplot(313), plot(t, theta);
title('Drehwinkel');
xlabel('Zeit in s');    grid on;