% Skript foerder_haft_gleit_1.m in dem die Frderung mit 
% Haft- und Gleitreibung simuliert wird. Arbeitet mit 
% Modell foerder_haft_gleit1.mdl
clear;
% -------- Parameter des Systems
g = 9.89;
% ------- Anregungsbewegung
ampl = 0.02;     % Amplitude der Anregungsbewegung
fanr = 4;      % Frequenz der Anregungsbewegung
mu = 0.5;        % Reibungskoeffizient
% ------- Simulation 
Tfinal = 5;
dt = 0.0001;
t = 0:dt:Tfinal;    nt = length(t);
% Initialisierungen
z = ampl*cos(2*pi*fanr*t);
vz = -ampl*2*pi*fanr*sin(2*pi*fanr*t);
az = -ampl*(2*pi*fanr)^2*cos(2*pi*fanr*t);
beta = pi/4;
x = z*cos(beta);      y = z*sin(beta);
vx = vz*cos(beta);    vy = vz*sin(beta);
ax = az*cos(beta);    ay = az*sin(beta);
% ------- Signale fr das Modell
ay_m = [t', ay'];       vx_m = [t', vx'];
% ------- Aufruf der Simulation
my_options = simset('solver', 'ode2', 'FixedStep', dt);
sim('foerder_haft_gleit1',[0,Tfinal], my_options);
t = y.time;
vxx = y.signals.values(:,1);
xx = y.signals.values(:,2);
Fr = y.signals.values(:,3);

figure(1);   clf;
nperioden = 5;
Tnperioden = 5/fanr;     nT = fix(Tnperioden/dt);
nd = nt - nT:nt;         % Darstellungen von 5 Perioden im
                         % stationren Zustand
% nd = 1:nt;             % Darstellung mit Einschwingen
axen(1) = subplot(411), plot(t(nd),(g+ay(nd)));
title(['Summe der Beschleunigungen (g+ay)']);
xlabel('Zeit in s');   grid on;   axis tight;
axen(2) = subplot(412), plot(t(nd), vxx(nd), t(nd), vx(nd),...
    t(nd),10*x(nd));
title(['Geschwindigkeiten vxx und vx' ,...
    ' bzw. Lage des Frderorgans 10*x']);
xlabel('Zeit in s');   grid on;   axis tight;
axen(3) = subplot(413), plot(t(nd), Fr(nd),...
    t(nd),sign(vxx(nd)-vx(nd)'));
title('Reibungskraft / m und Signum(vxx - vx)');
xlabel('Zeit in s');   grid on;   axis tight;
axen(4) = subplot(414), plot(t(nd), xx(nd));
title('Bewegung des Frderguts');
xlabel('Zeit in s');   grid on;   axis tight;
linkaxes([axen(1),axen(2),axen(3),axen(4)],'x');
