% Skript foerd_gleit_1, in dem eine Foerderung
% mit Gleitreibung untersucht wird
clear;

% ------- Parameter des Systems
ampl = 0.11;         fanr = 2;
mu = 0.9;            g = 9.89;
m2 = 0.1;
% ------- Schiefe Schwingungsanregung
Tfinal = 10;         dt = 0.0001;
t = 0:dt:Tfinal;     nt = length(t);
  
x = ampl*sin(2*pi*fanr*t);               % Schiefe Bewegung
vx = ampl*2*pi*fanr*cos(2*pi*fanr*t);    % Schiefe Geschwindigkeit
ax = - ampl*(2*pi*fanr)^2*cos(2*pi*fanr*t); % Schiefe Beschleunigung

betha = pi/5;     % Neigung der Feder (Winkel der Bewegung)
xx = x*cos(betha);    % Weg der Platte in x Richtung
vxx = vx*cos(betha);   % Geschwindigkeit Platte in x Richtung
vxy = vx*sin(betha);   % Geschwindigkeit Platte in y Richtung
axy = ax*sin(betha);   % Beschleunigung Platte in y Richtung
% Initialisierungen
x2 = zeros(1,nt);     v2x = x2;    FN = x2;
% ------- Lsung mit Euler-Verfahren 
for k = 1:nt-1
    if g-axy(k) >= 0;
        v2x(k+1) = v2x(k) - dt*(mu*(g-axy(k))*sign(v2x(k)-vxx(k)));
        FN(k) = mu*m2*(g-axy(k));
    else
        v2x(k+1) = v2x(k);
    end;  
    x2(k+1) = x2(k) + dt*v2x(k);
end;

figure(1);    clf;
subplot(311), plot(t, x2, t, xx);
title('Weg des Frderguts und der Frderplatte');
xlabel('Zeit in s');   grid on;

subplot(312), plot(t, v2x, t, vxx);
title('Geschwindigkeit des Frderguts und der Frderplatte');
xlabel('Zeit in s');   grid on;

subplot(313), plot(t, g - axy, t, FN*5);
title('g - axy und Normalkraft FN*5');
xlabel('Zeit in s');   grid on;
