% Skript feder_masse_12.m, in dem ein einfaches Feder-Masse-System
% untersucht wird
clear;
% ------- Parameter des Systems
w01 = 0.12;                 f01 = w01/(2*pi);  % Eigenfrequenz
zeta = [0.05,0.1:0.1:1];    nz = length(zeta);
% ------- bertragungsfunktionen
fmin = f01/10;              fmax = f01*10;
e1 = round(log10(fmin));    e2 = round(log10(fmax));
f = logspace(e1,e2,5000);   w = 2*pi*f;

figure(1);     clf;
for p = 1:nz
  b = 1;        % Koeffizienten der bertragungsfunktion k1.H(jw)      
  a = [1/(w01^2), 2*zeta(p)/w01, 1];                    
  Hf = freqs(b,a,w);
  subplot(211),  semilogx(f/f01, 20*log10(abs(Hf)));
    title(['|k1 * H(jw)| fr zeta = ',...
        num2str(zeta)]);  
    xlabel('f / f01');     grid on;   ylabel('dB');
    La = axis;        axis([0.2, 3,-20,La(4)]);
    set(gca,'XTick',[0.2:0.1:1,2:1:3]);
    hold on;
  subplot(212),  semilogx(f/f01, angle(Hf)*180/pi);
    title('Phasengang');      
    xlabel('f / f01');     grid on;   ylabel('Grad');
    La = axis;        axis([0.2,3,La(3:4)]);
    set(gca,'XTick',[0.2:0.1:1,2:1:3]);
    hold on;
end;   
hold off 







