% Skript feder_masse_11.m, in dem ein einfaches Feder-Masse-System
% untersucht wird
clear;
% ------- Parameter des Systems
m1 = 100;             k1 = 5000;     
w01 = sqrt(k1/m1);    f01 = w01/(2*pi), % Eigenfrequenz
c1 = [0.05, 0.1:0.1:1]*(2*w01*m1);    nc = length(c1);

% ------- bertragungsfunktionen
fmin = f01/10;               fmax = f01*10;
e1 = round(log10(fmin));    e2 = round(log10(fmax));
f = logspace(e1,e2,5000);   w = 2*pi*f;

figure(1);     clf;
for p = 1:nc
  b = 1;             % Koeffizienten der bertragungsfunktion       
  a = [m1, c1(p), k1];                    
  Hf = freqs(b,a,w);
  subplot(211),  semilogx(f/f01, 20*log10(abs(Hf)));
    title(['Amplitudengang fr c1 = ',num2str(c1(1)),' bis ',...
        num2str(c1(end))]);  
    xlabel('f / f1');     grid on;   ylabel('dB');
    La = axis;        axis([0.2, 3,-100,La(4)]);
    set(gca,'XTick',[0.2:0.1:1,2:1:3]);
    hold on;
  subplot(212),  semilogx(f/f01, angle(Hf)*180/pi);
    title('Phasengang');      
    xlabel('f / f1');     grid on;   ylabel('Grad');
    La = axis;        axis([0.2,3,La(3:4)]);
    set(gca,'XTick',[0.2:0.1:1,2:1:3]);
    hold on;
end;   
hold off
b = 1;                % Koeffizienten der bertragungsfunktion       
a = [m1, c1(1), k1];  % fr den kleinsten c1
ws = 0.1*w01;
% ws = 10*w01;
ws = w01;
Hws = polyval(b,j*ws)/polyval(a,j*ws);
Fex_ampl = 0.1,            % Amplitude der Anregung
xs_ampl = Fex_ampl*abs(Hws),







