% Skript dry_friction_1.m in dem eine Gleitreibung
% nach Dahl untersucht wird
clear;
% -------- Parameter
m = 380;
k = 2200;
e = 1e-4;
f = 500;
Fu = 800;     fu = 0.1; % N und rad/s
% -------- Aufruf der Simulation
Tfinal = 500;
dt = 0.001;      ts = [0,Tfinal];
my_options = simset('solver','ode2','FixedStep',dt);
%my_options = simset('solver','ode45','MaxStep',dt);

sim('dry_friction1',ts,my_options);
y1  = y.signals.values(:,1);
y2 = y.signals.values(:,2);
y3 = y.signals.values(:,3);
u =  y.signals.values(:,4);
t = y.time;
y11 = z.signals.values(:,1);
y12 = z.signals.values(:,2);
y13 = z.signals.values(:,3);

figure(1);   clf;
a1 = subplot(311), plot(t, y1);
title('Lage der Masse (Dahl Modell)');
xlabel('Zeit in s');    grid on;
a2 = subplot(312), plot(t, y2);
title('Geschwindigkeit der Masse');
xlabel('Zeit in s');    grid on;
a3 = subplot(313), plot(t, y3, t, u);
title('Reibungskraft und Anregungskraft');
xlabel('Zeit in s');    grid on;
linkaxes([a1,a2,a3], 'x');

figure(2);   clf;
a1 = subplot(311), plot(t, y11);
title('Lage der Masse (Signum Modell)');
xlabel('Zeit in s');    grid on;
a2 = subplot(312), plot(t, y12);
title('Geschwindigkeit der Masse');
xlabel('Zeit in s');    grid on;
a3 = subplot(313), plot(t, y13, t , u);
title('Reibungskraft und Anregungskraft');
xlabel('Zeit in s');    grid on;
linkaxes([a1,a2,a3], 'x');