% Skript coulomb_11.m in dem ein Slip-Stick
% System simuliert wird
clear;
% ------- Parameter des Systems
m = 10;     k = 10;     c = 0.0;
FH = 12;        % Haftreibungskraft
FG = 10;        % Gleitreibungskraft
vstr = 0.1;     % Stribeck Geschwindigkeit
vb = 0.1;       % Bandgeschwindigkeit

% ------- Simulation mit Euler-Verfahren
Tfinal = 100;           dt = 0.001;
t = 0:dt:Tfinal-dt;     nt = length(t)
y = zeros(1,nt);        vy = y;
Fr = y;
for p = 1:nt-1
   v_temp = (vy(p)-vb); 
   Fr(p+1) = (FG+(FH-FG)*exp(-abs(v_temp/vstr)))*sign(v_temp);
   vy(p+1) = vy(p) + dt*(-c*vy(p)-k*y(p)-Fr(p+1))/m;
   y(p+1) = y(p) + dt*vy(p+1);
end;

figure(1);    clf;
a1 = subplot(311), plot(t, vy-vb);
title('Relative Geschwindigkeit (vy - vb)'); 
xlabel('s');     grid on;
a2 = subplot(312), plot(t, y);
title('Lage der Masse');  xlabel('s');   grid on;
a3 = subplot(313), plot(t, k*y, t, -Fr);
title('Federkraft und minus Reibungskraft');  xlabel('s');   
grid on;    linkaxes([a1,a2,a3],'x');
