% Skript coulomb_1.m in dem die einfache
% Coulomsche Reibung untersucht wird. Arbeitet 
% mit Modell coulomb1.mdl
clear;
% ------- Parameter des Systems
m = 400;      c = 2200;  % Masse und viskose Koeffizient
FG = 500;         % Gleitreibung
Fex_ampl = 800;   % Amplitude der Anregugskraft    
fu = 0.02;        % Frequenz der Anregungskraft
v0 = 0;   y0 = 0; % Anfangsbedingungen
% -------- Aufruf der Simulation
Tfinal = 500;
dt = 0.001;      ts = [0,Tfinal];
%my_options = simset('solver','ode2','FixedStep',dt);
my_options = simset('solver','ode45','MaxStep',dt);

sim('coulomb1',ts,my_options);
y1  = y.signals.values(:,1);
y2 = y.signals.values(:,2);
y3 = y.signals.values(:,3);
u =  y.signals.values(:,4);
t = y.time;

figure(1);   clf;
subplot(311),  plot(t, y1);
title('Koordinate der Lage der Masse');
xlabel('Zeit in s');    grid on;
subplot(312),  plot(t, y2);
title('Geschwindigkeit der Masse');
xlabel('Zeit in s');    grid on;
subplot(313),  plot(t, u, t, y3);
title('Anregungs- und Reibungskraft');
xlabel('Zeit in s');    grid on;

