% ------------------------------------------------------
% Torque-Speed Curve for an Induction Motor
% Assumes the classical model
% This is a single-circuit model
% Required parameters are R1, X1, X2, R2, Xm, Vt, Ns
% Assumed is a three-phase motor
% This thing does a motoring, full speed range curve
% Copyright 1994 James L. Kirtley Jr.
% -------------------------------------------------------
Vt = 440;
R1 = 0.73;      % Stator Widerstand
R2 = 0.64;      % Rotor Widerstand
X1 = 0.06;      % Stator Reaktanz
X2 = 0.06;      % Rotor Reaktanz
Xm = 2.5;       % Magnetisierungsreaktanz
Ns = 1200;      % Sinchrongeschwindigkeit

s = .002:.002:1;   % vector of slip
N = Ns .* (1 - s); % Speed, in RPM
oms = 2*pi*Ns/60;  % Synchronous speed
Rr = R2 ./ s;      % Rotor resistance
Zr = j*X2 + Rr;    % Total rotor impedance
Za = (j*Xm*Zr)/(j*Xm + Zr); % Air-gap impedance
Zt = R1 + j*X1 +Za; % Terminal impedance
Ia = Vt ./ Zt;      % Terminal Current
I2 = Ia ./(Zr+j*Xm); % Rotor Current
Pag = 3 .* abs(I2) .^2 .* Rr; % Air-Gap Power
Pm = Pag .* (1 - s); % Converted Power
Trq = Pag ./ oms;   % Developed Torque
subplot(2,1,1)
plot(N, Trq)
title('Induction Motor');
ylabel('N-m');
subplot(2,1,2)
plot(N, Pm);
ylabel('Watts');
xlabel('RPM');