/* server */
var express = require('express')
  , app = express.createServer()
  , mongoose = require('mongoose') 
  , db = mongoose.createConnection('localhost', 'test');

/* models */
mongoose.connect('mongodb://127.0.0.1/sampledb');

var Schema = mongoose.Schema
  , ObjectId = Schema.ObjectID;

// schemas declared earlier in Mongoose section
var userSchema = ...
var bookSchema = ...
var commentSchema = ...

var Book    = db.model('Book', bookSchema);
var User    = db.model('User', userSchema);
var Comment = db.model('Comment', commentSchema);

//A new book, a new user, and a comment 
//about the new book by the new user:

var b1 = new Book({bookAuthor:  'Oswald Campesato', 
                   bookTitle:   'HTML5 Canvas and CSS3 Graphics',
                   bookPubDate: '07/30/2012' 
                  });

var u1 = new User({firstName:  'John', lastname: 'Smith'});
var c1 = new Comment(
         {userid: u1, bookid: b1, comment: "Great book!"});

// Add user u1 to the list of users (in b1) who have read the book:
b1.users.push(u1);

// Add book b1 to the list of books (in u1) that user u1 has read:
u1.books.push(b1);

//show books
app.get('/showbooks', function(req,res){
console.log("finding books");
    Book.find({}, function(error, data){
        res.json(data);
    });
});

//show users
app.get('/showusers', function(req,res){
console.log("finding users");
    User.find({}, function(error, data){
        res.json(data);
    });
});

// sample URL for adding a user:
//http://localhost:3003/adduser/tom/smith/pasta

app.get('/adduser/:first/:last/:username', function(req, res){
console.log("adding user");
    var user_data = {
        first_name: req.params.first
      , last_name: req.params.last
      , username: req.params.username
    };

    var user = new User(user_data);

    user.save( function(error, data){
        if(error){
            res.json(error);
        }
        else{
            res.json(data);
        }
    });
});	

app.listen(3003);
console.log("listening on port %d", app.address().port);

