from scipy import special, optimize
from numpy import sin,pi,linspace
from pylab import *

func = lambda x: -exp(-(x-10)**2)
sol = optimize.minimize(func, 8.0)
x = linspace(0, 200, 5000)

plot(x, special.jv(3, x), '-', sol.x, -sol.fun, 'o')
savefig('scipy1.png')

The first part of Listing 7.x contains import statements, followed by the definition of the lambda function func. Lambda functions are discussed in chapter tbd, but for the moment you can think of them as anonymous functions. In this example, func is defined in terms of an exponential function. 

The next portion of Listing 7.x defines the variable sol that is based on the minimize() function that belongs to the scip module. The variable x is a set of values defined in terms of the linspace() function that we discussed earlier in this chapter.

The last two lines of code in Listing 7.x generates and saves a plot based on the variables in this code sample.


