from Tkinter import *

import random 

root = Tk()
width  = 600 
height = 500

canvas = Canvas(root, bg='#d0d0d0', 
                height=500, width=600)

# set-up variables
upperX       = 40
upperY       = 40
deltaX       = 10
deltaY       = 10
barCount     = 10
barWidth     = 40
barHeight    = 0
barHeights   = [] 
minBarHeight = 20
maxBarHeight = 300
lineWidth    = 3
lineColor    = "#000000"
rectColor    = ""

# main loop
# render horizontal axis
lId = canvas.create_line(upperX-deltaX,
                         upperY+maxBarHeight+deltaY,
                         upperX+2*deltaX+barCount*barWidth,
                         upperY+maxBarHeight+deltaY,
                         fill=lineColor,width=lineWidth)

# render vertical axis
lId = canvas.create_line(upperX-deltaX,
                         upperY-deltaY,
                         upperX-deltaX,
                         upperY+maxBarHeight+deltaY,
                         fill=lineColor,width=lineWidth)

for b in range(0,barCount):
   randHeight = random.randrange(0, maxBarHeight) 

   if(randHeight < minBarHeight):
      randHeight = minBarHeight
   barHeights.append(randHeight)
 
print barHeights

# render line segments 
for b in range(1,barCount-1):
   if(b % 2 == 0):
     rectColor = "#" + "FF0000"
   else:
     rectColor = "#" + "FFFF00"
  
   pointX1 = upperX+(b-1)*barWidth
   pointY1 = upperY+barHeights[b-1]

   pointX2 = upperX+b*barWidth
   pointY2 = upperY+barHeights[b]

   rId = canvas.create_line(pointX1, pointY1, 
                            pointX2, pointY2,
                            fill=rectColor,width=lineWidth)

canvas.pack()
root.mainloop()

