from Tkinter import *

import random 

root = Tk()
width  = 600 
height = 500

canvas = Canvas(root, bg='#d0d0d0', 
                height=500, width=600)

# set-up variables
upperX       = 40
upperY       = 40
deltaX       = 10
deltaY       = 10
barCount     = 10
barWidth     = 40
slantX       = barWidth/2
slantY       = barWidth/4
barHeight    = 0
minBarHeight = 20
maxBarHeight = 300
lineWidth    = 3
lineColor    = "#000000"
rectColor    = ""
topColor     = "#eeeeee"
rightColor   = "#444444"
rectColors   = ["#FF0000", "#0000FF"]
points       = []
pGramWidth   = 1

# main loop
# render horizontal axis
lId = canvas.create_line(upperX-deltaX,
                         upperY+maxBarHeight+deltaY,
                         upperX+2*deltaX+barCount*barWidth,
                         upperY+maxBarHeight+deltaY,
                         fill=lineColor,width=lineWidth)

# render vertical axis
lId = canvas.create_line(upperX-deltaX,
                         upperY-deltaY,
                         upperX-deltaX,
                         upperY+maxBarHeight+deltaY,
                         fill=lineColor,width=lineWidth)

# render bar elements
for b in range(0,barCount):
   rectColor = rectColors[b % 2];
  
   upperLX = upperX+b*barWidth
   upperLY = upperY
 
   barHeight = random.randrange(0, maxBarHeight) 
   if(barHeight < minBarHeight):
      barHeight = minBarHeight
 
   # render front face 
   rId = canvas.create_rectangle(upperLX,
                                 upperLY+(maxBarHeight-barHeight),
                                 upperLX+barWidth,
                                 upperLY+maxBarHeight,
                                 fill=rectColor,width=1)

   # render top face (CCW from lower-left vertex)
   points = []
   points.append(upperLX) 
   points.append(upperLY+(maxBarHeight-barHeight))

   points.append(upperLX+barWidth) 
   points.append(upperLY+(maxBarHeight-barHeight))

   points.append(upperLX+barWidth+slantX) 
   points.append(upperLY+(maxBarHeight-barHeight)-slantY)

   points.append(upperLX+0*barWidth+slantX) 
   points.append(upperLY+(maxBarHeight-barHeight)-slantY)

   tId = canvas.create_polygon(points, outline='red', 
                               fill=topColor, width=pGramWidth)

   # render right face (CCW from upper-left vertex)
   points = []
   points.append(upperLX+barWidth) 
   points.append(upperLY+(maxBarHeight-barHeight))

   points.append(upperLX+barWidth) 
   points.append(upperLY+(maxBarHeight-barHeight)+barHeight)

   points.append(upperLX+barWidth+slantX) 
   points.append(upperLY+(maxBarHeight-barHeight)+barHeight-slantY)

   points.append(upperLX+barWidth+slantX) 
   points.append(upperLY+(maxBarHeight-barHeight)-slantY)

   tId = canvas.create_polygon(points, outline='red', 
                               fill=rightColor, width=pGramWidth)

canvas.pack()
root.mainloop()

