
import os, tempfile

text = b"hello bob"

def temp_opener(name, flag, mode=0o777):
    return os.open(name, flag | os.O_TEMPORARY, mode)

with tempfile.NamedTemporaryFile() as f:
    f.write(text)
    f.flush()
    with open(f.name, "rb", opener=temp_opener) as f:
        assert f.read() == text

assert not os.path.exists(f.name)

