import glob
import logging
import logging.handlers

# the name of the primary log file
LogFilename = 'rotatinglogger.txt'

# define a logger and its output level
my_logger = logging.getLogger('MyLogger')
my_logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
handler = logging.handlers.RotatingFileHandler(
              LogFilename, maxBytes=20, backupCount=3)

my_logger.addHandler(handler)

# Log some messages
for i in range(10):
    my_logger.debug('i = %d' % i)

# get the list of log-related filenames 
logfiles = glob.glob('%s*' % LogFilename)

# display the log filenames 
for filename in logfiles:
    print(filename)

