from Tkinter import *

import random 

root = Tk()
width  = 600 
height = 500

canvas = Canvas(root, bg='#d0d0d0', 
                height=500, width=600)

# set-up variables
upperX       = 40
upperY       = 40
deltaX       = 10
deltaY       = 10
barCount     = 10
barWidth     = 20
interBarXGap = barWidth/2
barHeight    = 0
minBarHeight = 20
maxBarHeight = 300
lineWidth    = 3
lineColor    = "#000000"
rectColor    = ""

# main loop
# render horizontal axis
lId = canvas.create_line(upperX-deltaX,
                         upperY+maxBarHeight+deltaY,
                         upperX+2*deltaX+barCount*(barWidth+interBarXGap),
                         upperY+maxBarHeight+deltaY,
                         fill=lineColor,width=lineWidth)

# render vertical axis
lId = canvas.create_line(upperX-deltaX,
                         upperY-deltaY,
                         upperX-deltaX,
                         upperY+maxBarHeight+deltaY,
                         fill=lineColor,width=lineWidth)

# render bar elements
for b in range(0,barCount):
   # RENDER LEFT VERTICAL RECTANGLES 
   if(b % 2 == 0):
     rectColor = "#" + "FF0000"
   else:
     rectColor = "#" + "FFFF00"
  
   upperLX = upperX+b*(barWidth+interBarXGap) 
   upperLY = upperY
 
   barHeight = random.randrange(0, maxBarHeight) 
   if(barHeight < minBarHeight):
      barHeight = minBarHeight

   # render upper half rectangle  
   rectColor = "#" + "FF0000"
   rId = canvas.create_rectangle(upperLX,
                                 upperLY+(maxBarHeight-barHeight),
                                 upperLX+barWidth/2,
                                 upperLY+(maxBarHeight-barHeight/2),
                                 fill=rectColor,width=1)
 
   # render lowr half rectangle  
   rectColor = "#" + "FFFF00"
   rId = canvas.create_rectangle(upperLX,
                                 upperLY+(maxBarHeight-barHeight/2),
                                 upperLX+barWidth/2,
                                 upperLY+maxBarHeight,
                                 fill=rectColor,width=1)


   # RENDER RIGHT VERTICAL RECTANGLES 
   if(b % 2 == 0):
     rectColor = "#" + "0000FF"
   else:
     rectColor = "#" + "00FF00"
  
   # render upper half rectangle  
   rId = canvas.create_rectangle(upperLX+barWidth/2,
                                 upperLY+(maxBarHeight-barHeight),
                                 upperLX+barWidth,
                                 upperLY+(maxBarHeight-barHeight/2),
                                 fill=rectColor,width=1)
 
   # render lowr half rectangle  
   rId = canvas.create_rectangle(upperLX+barWidth/2,
                                 upperLY+(maxBarHeight-barHeight/2),
                                 upperLX+barWidth,
                                 upperLY+maxBarHeight,
                                 fill=rectColor,width=1)

canvas.pack()
root.mainloop()

