#Exercise 1: Given a JSON string consisting of stock quotes and stock values, display a bar chart where each bar element represents the value of the stock. Make sure that you scale the bar chart so that the maximum height of any element is 200.

from Tkinter import *
import random 

stocks = {"A": "90.85", "B": "28.50", \
          "C": "80.52", "D": "37.91", \
          "E": "10.23", "F": "25.66", \
          "G": "30.80", "H": "60.25"}

root = Tk()
width  = 600 
height = 500

canvas = Canvas(root, bg='#d0d0d0', 
                height=500, width=600)

# set-up variables
upperX       = 40
upperY       = 40
deltaX       = 10
deltaY       = 10
barCount     = 0
barWidth     = 30
barHeight    = 0
minBarHeight = 20
maxBarHeight = 200
lineWidth    = 3
lineColor    = "#000000"
rectColor    = ""

# main loop
maxBarValue = 0
barHeights = []
# barCount equals the number of stock elements 
barCount = 0

# populate barHeights with value of each stock element
for item in stocks:
 #print 'item: %-10s' % item, 'stocks[item]:',stocks[item]
  floatHeight = float(stocks[item])
  barHeights.append(floatHeight)
  if(maxBarValue < floatHeight):
     maxBarValue = floatHeight 
  barCount += 1

# scale barHeights (if necessary)
if(maxBarValue > maxBarHeight):
   for b in range(0,barCount):
     barHeights[b] /= (maxBarHeight/maxBarValue)

# render horizontal axis
lId = canvas.create_line(upperX-deltaX,
                         upperY+maxBarHeight+deltaY,
                         upperX+2*deltaX+barCount*barWidth,
                         upperY+maxBarHeight+deltaY,
                         fill=lineColor,width=lineWidth)

# render vertical axis
lId = canvas.create_line(upperX-deltaX,
                         upperY-deltaY,
                         upperX-deltaX,
                         upperY+maxBarHeight+deltaY,
                         fill=lineColor,width=lineWidth)

# render all the bar elements
for b in range(0,barCount-1):
   if(b % 2 == 0):
     rectColor = "#" + "FF0000"
   else:
     rectColor = "#" + "FFFF00"
  
   upperLX = upperX+b*barWidth
   upperLY = upperY
 
   upperRX = upperX+(b+1)*barWidth
   upperRY = upperY
 
  #barHeight = random.randrange(0, maxBarHeight) 
   barHeightL = barHeights[b] 
   barHeightR = barHeights[b+1] 

   if(barHeightL < minBarHeight):
      barHeightL = minBarHeight
 
   if(barHeightR < minBarHeight):
      barHeightR = minBarHeight
 
   # CW from upper-left vertex 
   rId = canvas.create_polygon(upperLX,
                               upperLY+(maxBarHeight-barHeightL),
                               upperRX,
                               upperRY+(maxBarHeight-barHeightR),
                               upperRX,
                               upperRY+(maxBarHeight),
                               upperLX,
                               upperLY+(maxBarHeight),
                               fill=rectColor,width=1)

canvas.pack()
root.mainloop()

