import sys
import svgwrite

basename = sys.argv[0].rstrip('py')
svgname  =  basename+'svg'
myText   = "This is a line of text"

def createSVG(name):
    svgWidth  = 600
    svgHeight = 300
    font_size = 20
    fontSize  = 28
    wFactor   = 2

    svgTitle  = 'Text Strings and Generic Fonts'
    colors    = ('#ff0000','#ffff00','#88ff88','#0000ff')
    cCount    = len(colors)

    FFS = ('cursive','monospace','sans-serif','serif')
    dwg = svgwrite.Drawing(name, (svgWidth, svgHeight), debug=True)

    # grey background (#cccccc) 
    dwg.add(dwg.rect(insert=(0, 0), size=('100%', '100%'), fill='#cccccc'))

    # Add the title string 
    dwg.add(dwg.text(svgTitle, insert=(0, (fontSize+5)),
            font_family="serif", font_size=fontSize, fill='black'))

    for index in range(len(FFS)):
        font = FFS[index]
        fill = colors[index % cCount]

        dwg.add(dwg.text(font+": "+myText, 
            insert=(font_size, fontSize*(index*wFactor+4)),
            font_family=font, font_size=fontSize, fill=fill))

    dwg.save()

if __name__ == '__main__':
    createSVG(basename + 'svg')

