from lxml import etree

filename = 'Parse1.svg'
svgTree  = etree.parse(open(filename,'r'))

#Array of Attribute Values 
attributeValues = []

for elem in svgTree.iter():
  tagName = elem.tag.split( "}" )[0]
  print 'Element Name: ', tagName
  
  #check for rectangle/lines
  if tagName == 'rect': 
    x = elem.get('x')
    y = elem.get('y')
    width  = elem.get('width')
    height = elem.get('height')

    attributeValues.append(x)
    attributeValues.append(y)
    attributeValues.append(width)
    attributeValues.append(height)

    print 'Detected a Rectangle'
    print 

  if tagName == 'line': 
    x1 = elem.get('x1')
    y1 = elem.get('y1')
    x2 = elem.get('x2')
    y2 = elem.get('y2')

    attributeValues.append(x1)
    attributeValues.append(y1)
    attributeValues.append(x2)
    attributeValues.append(y2)

    print 'Detected a Line Segment'
    print 

 #if tagName == 'ellipse': 
   #do something here

print 'List of Attribute Values:'
for attrValue in attributeValues:
  print attrValue 

