from Tkinter import *

import random 

root = Tk()
width  = 600 
height = 500

canvas = Canvas(root, bg='#d0d0d0', 
                height=500, width=600)

# set-up variables
upperX       = 40
upperY       = 40
deltaX       = 10
deltaY       = 10
barCount     = 10
barWidth     = 20
barHeight    = 0
minBarHeight = 20
maxBarHeight = 300
lineWidth    = 3
lineColor    = "#000000"
rectColor    = ""

# main loop
# render horizontal axis
lId = canvas.create_line(upperX-deltaX,
                         upperY+maxBarHeight+deltaY,
                         upperX+2*deltaX+barCount*barWidth,
                         upperY+maxBarHeight+deltaY,
                         fill=lineColor,width=lineWidth)

# render vertical axis
lId = canvas.create_line(upperX-deltaX,
                         upperY-deltaY,
                         upperX-deltaX,
                         upperY+maxBarHeight+deltaY,
                         fill=lineColor,width=lineWidth)

# render bar elements
for b in range(0,barCount):
   if(b % 2 == 0):
     rectColor = "#" + "FF0000"
   else:
     rectColor = "#" + "FFFF00"
  
   upperLX = upperX+b*barWidth
   upperLY = upperY
 
   barHeight = random.randrange(0, maxBarHeight) 
   if(barHeight < minBarHeight):
      barHeight = minBarHeight
 
   rId = canvas.create_rectangle(upperLX,
                                 upperLY+(maxBarHeight-barHeight),
                                 upperLX+barWidth,
                                 upperLY+maxBarHeight,
                                 fill=rectColor,width=1)

canvas.pack()
root.mainloop()

