import threading
import Queue
import time

threadCount=3
maxCount=15
delayTime = 0.4

print 'Thread Count:   ',threadCount
print 'Number of Tasks:',maxCount
print 'Task delay:     ',delayTime 

# lock to serialize console output
lock = threading.Lock()

def performCalculations(item):
  # simulate lengthy calculation
  time.sleep(delayTime) 

  # prevent threads from mixing output on the same line
  with lock:
    print threading.current_thread().name,item 

# Each worker thread processes a queue item
def invokeWorker():
  while True:
    item = q.get()
    performCalculations(item)
    q.task_done()

# Create the queue and thread pool
q = Queue.Queue()
for i in range(threadCount):
  t = threading.Thread(target=invokeWorker)
  # thread dies when main thread (only non-daemon thread) exits
  t.daemon = True  
  t.start()

startTime = time.time()

for item in range(maxCount):
    q.put(item)

# block until all tasks are completed 
q.join()      

# display elapsed time 
now = time.time() 
elapsedTime = now - startTime
print 'Elapsed time:', elapsedTime 

