package main

import (
   "math"
   "os"
   "github.com/ajstarks/svgo"
)

func main() {
   var offsetX, offsetY, radius float64

   basePointX   := 240
   basePointY   := 250
   majorAxis    := 60
   minorAxis    := 120
   currentX     := 0
   currentY     := 0
   Constant     := 0.25
   deltaAngle   := 1
   maxAngle     := 721
   screenWidth  := 600
   screenHeight := 500
 //strokeStyle  := ""

   radial1 := []svg.Offcolor{
      {10, "#00cc00", 1},
      {30, "#006600", 1},
      {70, "#cc0000", 1},
      {90, "#000099", 1}}

     g := svg.New(os.Stdout)
     g.Start(screenWidth, screenHeight)
     g.Title("Radial Gradients")
     g.Rect(0, 0, screenWidth, screenHeight, "fill:white")
     g.Def()
       g.RadialGradient("radial1", 50, 50, 100, 25, 25, radial1)
     g.DefEnd()

   for angle := 0; angle<maxAngle; angle+=deltaAngle  {
      radius   = Constant*float64(angle);
      offsetX  = radius*math.Cos(float64(angle)*math.Pi/180);
      offsetY  = radius*math.Sin(float64(angle)*math.Pi/180);
      currentX = basePointX+int(offsetX);
      currentY = basePointY-int(offsetY);

      // draw the current ellipse
      g.Ellipse(currentX, currentY,
                angle % majorAxis, angle % minorAxis,
                "fill:url(#radial1)")
   }

   g.End()
}

