% Skript vierpol_leit1.m in dem das Vierpolmodell
% eines JFET-Transistor untersucht wird

clear;
% ------- Parameter der Schaltung
Cgs = 3e-12;    Cdg = 1e-12;
rds = 10e6;
gm = 10e-3;     RL = 10e3;
% ------- Frequenzbereich
fmin = 1e6;
fmax = 1000e6;
a1 = floor(log10(fmin));
a2 = ceil(log10(fmax));
f = logspace(a1, a2, 1000);
omega = 2*pi*f;

% ------- Leitwertmodell
Y11 = j*omega*(Cgs + Cdg);
Y12 = -j*omega*Cdg;
Y21 = gm - j*omega*Cdg;
Y22 = 1/rds + j*omega*Cdg;

% ------- Eingangsimpedanz als Ri + 1/j*omega*Ci
Zi = 1./(Y11-Y12.*Y21.*RL./(1+Y22*RL));

Ri = real(Zi);
Ci = -1./(omega.*imag(Zi));

figure(1);   clf;
subplot(221), loglog(f, Ri);
title('Eingangswiderstand der Reihenschaltung');
xlabel('Hz');    grid on;
La = axis;   axis([min(f),max(f),min(Ri)/10, 10*max(Ri)]);

subplot(223), loglog(f, Ci);
title('Eingangskapazitt der Reihenschaltung');
xlabel('Hz');    grid on;
La = axis;   axis([min(f),max(f),min(Ci)/10, 10*max(Ci)]);

% ------- Eingangsleitwert als 1/Ri + j*omega*Ci
Yi = 1./Zi;
Ri = 1./real(Yi);
Ci = imag(Yi)./omega;

subplot(222), loglog(f, Ri);
title('Eingangswiderstand der Parallelschaltung');
xlabel('Hz');    grid on;
La = axis;   axis([min(f),max(f),min(Ri)/10, 10*max(Ri)]);
subplot(224), loglog(f, Ci);
title('Eingangskapazitt der Parallelschaltung');
xlabel('Hz');    grid on;
La = axis;   axis([min(f),max(f),min(Ci)/10, 10*max(Ci)]);

% ------- Verstrkung U2/U1
H = -Y21*RL./(1 + Y22*RL);

figure(2);    clf;
subplot(211), semilogx(f, 20*log10(abs(H)));
title('Amplitudengang U2/U1');   ylabel('dB')
xlabel('Hz');    grid on;

subplot(212), semilogx(f, angle(H)*180/pi);
title('Phasengang');       ylabel('Grad')
xlabel('Hz');    grid on; 

% ------ Verstrkung U2/Ug mit einem neuen Frequenzbereich
% ------- Frequenzbereich
fmin = 1e4;
fmax = 10e6;
a1 = floor(log10(fmin));
a2 = ceil(log10(fmax));
f = logspace(a1, a2, 1000);
omega = 2*pi*f;

% ------- Leitwertmodell fr den neuen Frequenzbereich
Y11 = j*omega*(Cgs + Cdg);
Y12 = -j*omega*Cdg;
Y21 = gm - j*omega*Cdg;
Y22 = 1/rds + j*omega*Cdg;

% ------- Eingangsimpedanz fr den neuen Frequenzbereich
Zi = 1./(Y11-Y12.*Y21.*RL./(1+Y22*RL));
% ------- Frequenzgang fr den neuen Frequenzbereich
H = -Y21*RL./(1 + Y22*RL);

Rg = 10e3;
H1 = H.*Zi./(Rg + Zi);

figure(3);    clf;
subplot(211), semilogx(f, 20*log10(abs(H1)));
title(['Amplitudengang U2/Ug (Rg = ',num2str(Rg),' Ohm)']);   ylabel('dB')
xlabel('Hz');    grid on;

subplot(212), semilogx(f, angle(H1)*180/pi);
title('Phasengang');       ylabel('Grad')
xlabel('Hz');    grid on; 



