% Skript vierpol_hybrid1.m in dem ein Verstrker mit
% Bipolaren-Transistor mit Hilfe der Hybrid-Parameter
% des Vierpols untersucht wird

clear;
% ------- Parameter der Schaltung
C_cb = 1e-12;     r_ce = 100e3;
r_pi = 100;       gm = 10e-3;
RL = 10e3;
% ------- Frequenzbereich
fmin = 100e3;        fmax = 10000e6;
a1 = floor(log10(fmin));      a2 = ceil(log10(fmax));
f = logspace(a1, a2, 5000);
omega = 2*pi*f;

% ------- Hybridmodell des Bipolaren-Transistors
H11 = r_pi./(j*omega*r_pi*C_cb + 1);
H12 = j*omega*r_pi*C_cb./(j*omega*r_pi*C_cb + 1);
H21 = r_pi*(gm - j*omega*C_cb)./(j*omega*r_pi*C_cb + 1);
H22 = 1/r_ce + j*omega*C_cb*(gm*r_pi+1)./(j*omega*r_pi*C_cb + 1);

% ------- Eingangsimpedanz
Zi = H11 - H12.*H21.*(RL./(1 + RL*H22));
betrag_Zi = abs(Zi);    winkel_Zi = angle(Zi)*180/pi;

% ------- bertragungsfunktion U2/U1
G = -(H21*RL./(H11.*(1+RL*H22)))./(1-H21.*H12*RL./(H11.*(1+RL*H22)));

figure(1);    clf;
subplot(211), semilogx(f, 20*log10(abs(G)));
title('Amplitudengang U2/U1');   ylabel('dB')
xlabel('Hz');    grid on;

subplot(212), semilogx(f, angle(G)*180/pi);
title('Phasengang');       ylabel('Grad')
xlabel('Hz');    grid on; 

figure(2);   clf;
subplot(211), loglog(f, betrag_Zi);
title('Betrag der Eingangsimpedanz');
xlabel('Hz');    ylabel('Ohm');   grid on;
La = axis;   
axis([min(f),max(f),min(betrag_Zi)/10, 10*max(betrag_Zi)]);

subplot(212), semilogx(f, angle(Zi)*180/pi);
title('Winkel der Eingangsimpedanz');
xlabel('Hz');    ylabel('Grad');   grid on;
La = axis;   
axis([min(f),max(f), min(winkel_Zi), max(winkel_Zi)]);

% ------- bertragungsfunktion U2/Ug
Rg = 1e3;
G1 = G.*Zi./(Zi + Rg);

figure(3);    clf;
subplot(211), semilogx(f, 20*log10(abs(G1)));
title(['Amplitudengang U2/Ug (Rg = ',num2str(Rg),' Ohm)']);   
xlabel('Hz');    grid on;    ylabel('dB')

subplot(212), semilogx(f, angle(G1)*180/pi);
title('Phasengang');       ylabel('Grad')
xlabel('Hz');    grid on; 

% -------- Frequenzgang H direkt (bertragungsfunktion U2/U1)
RL_ce = RL*r_ce/(RL + r_ce);
G = -RL_ce*(gm-j*omega*C_cb)./(j*omega*C_cb*RL_ce + 1);

figure(4);    clf;
subplot(211), semilogx(f, 20*log10(abs(G)));
title('Amplitudengang U2/U1 (direkt berechnet)');   ylabel('dB')
xlabel('Hz');    grid on;

subplot(212), semilogx(f, angle(G)*180/pi);
title('Phasengang');       ylabel('Grad')
xlabel('Hz');    grid on;
