% Skript vierpol_fet1.m in dem ein Verstrker mit
% FET-Transistor mit Hilfe der Impedanzparameter
% des Vierpols untersucht wird

clear;
% ------- Parameter der Schaltung
C_dg = 1e-12;     C_gs = 2e-12;   
r_ds = 10e6;
gm = 10e-3;
RL = 10e3;        Rg = 10e3;
RS = 1e3;

% ------- Frequenzbereich
fmin = 10e3;        fmax = 1000e6;
a1 = floor(log10(fmin));      a2 = ceil(log10(fmax));
f = logspace(a1, a2, 5000);
omega = 2*pi*f;
no = length(omega);

Y = zeros(2,2,no);
Z = Y;
G  = zeros(1,no);
G1 = zeros(1,no);     Zi = zeros(1,no);

% ------- Kennwerte des FET-Verstrkers
for k = 1:no
  Y(:,:,k) = [j*omega(k)*(C_gs + C_dg),  -j*omega(k)*C_dg;
          gm - j*omega(k)*C_dg, 1/r_ds+j*omega(k)*C_dg];
  Z(:,:,k) = inv(Y(:,:,k)) + ones(2,2)*RS;
  G(k) = Z(2,1,k)*RL/(Z(1,1,k)*(Z(2,2,k)+RL)-Z(1,2,k)*Z(2,1,k));
  Zi(k) = Z(1,1,k)-Z(1,2,k)*Z(2,1,k)./(Z(2,2,k)+RL);
  G1(k) = G(k).*Zi(k)./(Rg + Zi(k));
end;

% ------ Frequenzgang U2/U1
figure(1);    clf;
subplot(211), semilogx(f, 20*log10(abs(G)));
   title('Amplitudengang U2/U1');   ylabel('dB')
   xlabel('Hz');    grid on;
subplot(212), semilogx(f, angle(G)*180/pi);
   title('Phasengang');       ylabel('Grad')
   xlabel('Hz');    grid on; 
% ------ Eingangsimpedanz
betrag_Zi = abs(Zi);    winkel_Zi = angle(Zi)*180/pi;  

figure(2);   clf;
subplot(211), loglog(f, betrag_Zi);
   title('Betrag der Eingangsimpedanz');
   xlabel('Hz');    ylabel('Ohm');   grid on;
   La = axis;   
   axis([min(f),max(f),min(betrag_Zi)/10, 10*max(betrag_Zi)]);
subplot(212), semilogx(f, winkel_Zi);
   title('Winkel der Eingangsimpedanz');
   xlabel('Hz');    ylabel('Grad');   grid on;
   La = axis;   
   axis([min(f),max(f), min(winkel_Zi), max(winkel_Zi)]);
% ------ Frequenzgang U2/Ug
figure(3);    clf;
subplot(211), semilogx(f, 20*log10(abs(G1)));
   title(['Amplitudengang U2/Ug (Rg = ',num2str(Rg),' Ohm)']);   
   xlabel('Hz');    grid on;    ylabel('dB')
subplot(212), semilogx(f, angle(G1)*180/pi);
   title('Phasengang');       ylabel('Grad')
   xlabel('Hz');    grid on; 


