% Skript zweiweg_gleich1.m in dem eine
% Zweiweggleichrichtung mit Glttung durch
% Induktivitt und Kapazitt untersucht wird

clear;
% ------ Parameter der Schaltung
Rg = 1;    R = 50;    
E0 = 0.7;  rD = 0.5;  % Parameter der Diode
L = 0.2;   C = 500e-6
f = 50;    T = 1/f;
ampl = 100;
omega = 2*pi*f;

% ------ Numerische Lsung
dt = T/1000;
t = 0:dt:10*T-dt;
ug = abs(ampl*sin(2*pi*f*t));
nt = length(t);

iL = zeros(1,nt);    uL = iL;
uc = iL;

for k = 1:nt-1;
    iL(k+1) = iL(k) + dt*(ug(k) - E0 - iL(k)*(rD + Rg) - uc(k))/L;
    if iL(k+1) < 0
        iL(k+1) = 0;
    end;
    uc(k+1) = uc(k) + dt*(iL(k+1) - uc(k)/R)/C;
end;
uL = ug - E0 - iL*(rD + Rg) - uc;
k = find(iL == 0);
uL(k) = 0;

figure(1);    clf;
plot(t,ug/20, t,uL/20, t,iL, t,uc/20);
title('ug/20, uL/20, iL,  uc/20');
xlabel('Zeit in s');  grid on;









