% Skript vdr_3.m in dem eine Schaltung mit
% spannungsabhngigen Widerstand untersucht wird.
% Es wird ein linearen- und VDR-Widerstand parallel zu 
% einer geschalteten Induktivitt simuliert

clear
% ------ Parameter der Schaltung
Uv = 50;       Iv = 1e-3;
gamma = 13;

% ------ Kennlinie des VDR-Widerstands
u = -100:1:100;
i = Iv*(u/Uv).^gamma;

figure(1);    clf;
plot(u,i);
title('Kennlinie des VDR-Widerstands');
xlabel('V');   grid on;
ylabel('A');

% ------- Numerisches Integrationsverfahren
% Initialisierungen
f = 2e3;   T = 1/f;
L = 0.05;
R = 1e3;
Ue = 20;

dt = 0.000001;
t = 0:dt:5*T-dt;
nt = length(t);

i1  = zeros(1,nt);   i2 = i1;
ua1 = i1;            ua2 = ua1;
us = sign(sin(2*pi*f*t));

for k = 1:nt-1;
    if us(k) > 0 
       i1(k+1) = i1(k) + dt*Ue/L;
       i2(k+1) = i2(k) + dt*Ue/L;
        if i1(k+1) <= 0
              i1(k+1) = 0;
        end;
        if i2(k+1) <= 0
              i2(k+1) = 0;
        end;
        ua1(k+1) = Ue;    ua2(k+1) = Ue;
    else
       i1(k+1) = i1(k) - dt*i1(k)*R/L; 
       i2(k+1) = i2(k) - dt*(Uv*((i2(k)/Iv)^(1/gamma)))/L;
        if i1(k+1) <= 0
              i1(k+1) = 0;
        end;
        if i2(k+1) <= 0
              i2(k+1) = 0;
        end;
        ua1(k+1) = -i1(k+1)*R;
        ua2(k+1) = -Uv*(i2(k+1)/Iv).^(1/gamma);
    end;    
end;

figure(2);
subplot(211), plot(t, i1, t, i2);
title('Stroeme');
xlabel('Zeit in s');   grid on;
subplot(212), plot(t, ua1, t, ua2);
title('Spannungen');
xlabel('Zeit in s');   grid on;
La = axis;    axis([La(1:3), La(4)*1.3]);






