% Skript vdr_1.m in dem eine Schaltung mit
% spannungsabhngigen Widerstand untersucht wird
% Die Schaltung ist mit sinusfrmige Quelle angeregt
function [ua, ia] = vdr_2

global Ug R Uv Iv gamma 
% ------ Parameter der Schaltung
Uv = 30;
Iv = 1e-3;
gamma = 13;

% ------ Kennlinie des VDR-Widerstands
u = -60:1:60;
i = Iv*(u/Uv).^gamma;

figure(1);    clf;
plot(u,i);
title('Kennlinie des VDR-Widerstands');
xlabel('V');   grid on;
ylabel('A');

% ------ Arbeitspunkte-Berechnung mit fsolve
R = 0.1e3;
f = 50;    T = 1/f;
t = 0:0.5e-3:5*T;
nt = length(t);

ampl = 200;
ug = ampl*cos(2*pi*f*t);
ua = zeros(1,nt);
for k = 1:nt
    Ug = ug(k);
    ua(k) = fsolve(@fa,0,optimset('Display','off'));
%    ua(k) = fsolve(@fa,0);   % Die Angaben ber die Lsung
               % bei jedem Schritt werden gezeigt
end;    
ia = Iv*(ua/Uv).^(gamma);

figure(2);
subplot(211), plot(t, ua, t, ug);
title('Anregung und Spannung am VDR-Widerstand');
xlabel('Zeit in s');    grid on;

subplot(212), plot(t,ia);
title('Strom des VDR-Widerstands');
xlabel('Zeit in s');    grid on;

%############################################
function y = fa(x);
% (Ug-x)/R -Iv*(x/Uv)^gama = 0; Funktion deren Nullwert
% zu ermitteln ist
global Ug R Uv Iv gamma

y = (Ug - x)/R - Iv*(x./Uv).^gamma;


