% Skript vdr_1.m in dem eine Schaltung mit
% spannungsabhngigen Widerstand untersucht wird
function ua = vdr_1

global Ug R Uv Iv gamma

% ------ Parameter der Schaltung
Uv = 40;
Iv = 0.1e-3;
gamma = 11;

% ------ Kennlinie des VDR-Widerstands

u = -100:1:100;
i = Iv*(u/Uv).^gamma;

figure(1);    clf;
subplot(311), plot(u,i);
title('Kennlinie des VDR-Widerstands');
xlabel('V');   grid on;
ylabel('A');

% Differentieller Widerstand
r = diff(u)./diff(i);

subplot(312), semilogy(u(2:end),r);
title('Differentieller Widerstand');
xlabel('V');   grid on;
ylabel('Ohm');

% Statischer Widerstand
R = u./i;

subplot(313), semilogy(u,R);
title('Statischer Widerstand');
xlabel('V');   grid on;
ylabel('Ohm');

% ------- Arbeitspunkt Bestimmung
Ug = 100;    R = 1e3;   % Parameter der Schaltung

% ------ Arbeitspunkt-Berechnung mit fsolve
ua = fsolve(@fa, 0);

%############################################
function y = fa(x);
% (Ug-x)/R -Iv*(x/Uv)^gama = 0; Funktion deren Nullwert
% zu ermitteln ist
global Ug R Uv Iv gamma

y = (Ug - x)/R - Iv*(x./Uv).^gamma;


