% Skript vdr_0.m in dem eine einfache Schaltung mit
% spannungsabhngigen Widerstand untersucht wird
function [ua1, ua2, k] = vdr_0

global Ug Uv Iv R gamma

% ------ Parameter der Schaltung
Uv = 40;      Iv = 0.1e-3;
gamma = 11;
% ------ Kennlinie des VDR-Widerstands
u = -80:1:80;
i = Iv*(u/Uv).^gamma;

figure(1);    clf;
plot(u,i);
title('Kennlinie des VDR-Widerstands');
xlabel('V');   grid on;
ylabel('A');
% ------ Parameter der Schaltung
Ug = 100;     R = 1e3;
hold on;
plot([Ug 0], [0, Ug/R]);  % Belastungsgerade
hold off;
% ------ Arbeitspunkt-Berechnung mit fsolve
ua1 = fsolve(@fa, 0);
% ------ Arbeitspunkt-Berechnung mit einfache Iteration
ua2 = 0;
k = 1;
while k < 10
    ua2_neu = Uv*((Ug - ua2)/(R*Iv))^(1/gamma);
    if abs(ua2_neu - ua2) < 0.001
        break
    end;    
    ua2 = ua2_neu;
    k = k+1;
end;    
%############################################
function y = fa(x);
% (Ug-x)/R -Iv*(x/Uv)^gama = 0; Funktion deren Nullwert
% zu ermitteln ist
global Ug Uv Iv R gamma

y = (Ug - x)/R - Iv*((x./Uv).^gamma);


