% trafo_diode_1.m

clear;
% ------- Parameter der Schaltung
Rg = 10;        Rs = 100;      C = 100e-6;
l1 = 0.0001;
l2 = l1;
L = 0.005;
VT = 25e-3;
I0 = 1e-6;


% ------- Simulation mit Euler-Verfahren
f = 20000;
T = 1/f;             dt = T/500;
t = 0:dt:500*T;      nt = length(t);
ampl = 10;
ug = ampl*sin(2*pi*f*t);

%   ug = ampl*sign(cos(2*pi*f*t));
%ug = (ampl*sign(sin(2*pi*f*t)) + ampl)/2;

% Initialisierungen
i1 = zeros(1,nt);    ud = i1;     uc = i1;

ni = 10;
i1_temp = i1(1);      ud_temp = ud(1);     uc_temp = uc(1)

for k = 1:nt-1    
    uc_temp = uc_temp + dt*(I0*(exp(ud_temp/VT)-1) - uc_temp/Rs)/C;
    di2_dt = ((ug(k) - i1_temp*Rg)*L - (ud_temp + uc_temp)*(l1+L))/(l1*l2 + (l1+l2)*L);
    ud_temp = ud_temp + dt*(di2_dt)*VT*(exp(-ud_temp/VT))/I0;
    if ud_temp > 0.7
        ud_temp = 0.7;
    end;    

    di1_dt = ((l2+L)*di2_dt + (ud_temp + uc_temp))/L;
    i1_temp = i1_temp + dt*(di1_dt);
%
    i1(k+1) = i1_temp;
    ud(k+1) = ud_temp;
    uc(k+1) = uc_temp;
end;
