% Programm trafo_34.m in dem ein Transformator
% mit Einweggleichrichtung und resistiver 
% Verbraucher mit Simulink-Modell trafo_3_4.mdl 
% simuliert wird

clear;
% ------- Parameter der Schaltung
Rw1 = 1;         Ls1  = 0.00001;
Rw21 = 1;        Ls21 = 0.00001;
L = 0.005;      R21 = 100;
%L = 0.001;
Rg = 10;
Is = 10e-9;     VT = 25e-3;

% ------- Simulation mit Simulink-Modell
f = 20000;
%T = 1/f;        dt = T/500;   % Fr Sinusanregung
T = 1/f;        dt = T/2000; % Fr Rechteckanregung
ampl = 10;

my_options = simset('Solver','ode45','Maxstep', dt);
sim('trafo_3_4',[0,50*T], my_options);    % Variable Schrittweite

i1 =  iy(:,1);     i21 = iy(:,2);
im = i1 - i21;

figure(1);
nt = length(t);
nd = nt-5000:nt;
%nd = 1:nt;

subplot(311), plot(t(nd), i1(nd));
  title('Strom i1');
  xlabel('Zeit in s');  grid on;
  La = axis;   axis([t(nd(1)), t(nd(end)), La(3),...
      1.1*max(i1(nd))]);
subplot(312), plot(t(nd), i21(nd));
  title('Strom i21');
  xlabel('Zeit in s');    grid on;
  La = axis;   axis([t(nd(1)), t(nd(end)), La(3:4)]);
subplot(313), plot(t(nd), im(nd));
  title('Strom im');
  xlabel('Zeit in s');  grid on;
  La = axis;   axis([t(nd(1)), t(nd(end)), La(3:4)]);




