% Programm trafo_3.m in dem ein Transformator mit Einweggleichrichtung 
% und resistiver Verbraucher simuliert wird
clear;
% ------- Parameter der Schaltung
Rw1 = 1;         Ls1 = 0.0001;
Rw21 = 1;        Ls21 = 0.0001;
L = 0.01;        R21 = 100;
Rg = 10;
% ------- Matrizen des Systems, wenn die Dode leitend ist
Ai = [Ls1+L, -L; L, -(L+Ls21)];
Bi = [-(Rw1+Rg), 0; 0, (Rw21+R21)];
Ci = [1, 0]';
% ------- Zustandsmatrizen A, B, C, D
E = inv(Ai);
A1 = E*Bi;            B1 = E*Ci;
C1 = eye(2);          D1 = [0, 0]';
% ------- Zustandsmatrizen des Systems, 
%                  wenn die Dode blockiert ist
A2 = [-(Rw1+Rg)/(L+Ls1), 0; 0, 0];
B2 = [1/(L+Ls1), 0]';
C2 = C1;  D2 = D1;
% ------- Simulation mit Euler-Verfahren
f = 20000;
T = 1/f;             dt = T/200;
t = 0:dt:100*T;      nt = length(t);
ampl = 10;

ug = ampl*cos(2*pi*f*t);   % Sinus-Anregung
ug = ampl*sign(cos(2*pi*f*t)); % Bipolare rechteckige Anregung
%ug = ampl*(sign(cos(2*pi*f*t))+1)/2; % Unipolare rechteckige
% Initialisierungen
i = zeros(2,nt);      % i(1,:) = i1;                % i(2,:) = i21;
ni = 10;
% ni = 100;        % bessere Genauigkeit (dauert lnger)
dti = dt/ni;
u_La = zeros(1,nt); 
i_temp = i(:,1); 
uLa = u_La(1);
% Euler-Verfahren
for k = 1:nt-1
    for p = 1:ni
      if i_temp(2) > 0;    % Diode leitend
         uLa = ug(k) - i_temp(1)*(Rg +Rw1) ...
          - Ls1*(A1(1,1)*i_temp(1)+A1(1,2)*i_temp(2)+B1(1)*ug(k)) ...
          - Ls21*(A1(2,1)*i_temp(1)+A1(2,2)*i_temp(2)+B1(2)*ug(k));
      else
         uLa = ug(k)-i_temp(1)*(Rg+Rw1)-Ls1*(A2(1,1)*i_temp(1)+ ...
             A2(1,2)*i_temp(2) + B2(1)*ug(k));  % Diode blockiert
      end   
      if uLa < 0;         % Diode blockiert
         i_temp(2) = 0; 
         i_temp = dti*(A2*i_temp + B2*ug(k)) + i_temp;
      else                % Diode leitend
         i_temp = dti*(A1*i_temp + B1*ug(k)) + i_temp;    
      end;
    end;
    i(:,k+1) = i_temp;
    u_La(k+1) = uLa;
end;
im = i(1,:) - i(2,:);    % Magnetisierungsstrom
figure(1);
nd = nt-1000:nt;
subplot(311), plot(t(nd), i(1,nd)*10, t(nd), ug(nd)/10);
  title('Strom i1*10 und ug/10');
  xlabel('Zeit in s');  grid on;
  La = axis;   axis([t(nd(1)), t(nd(end)), 1.1*La(3:4)]);
subplot(312), plot(t(nd), i(2,nd));
  title('Strom i21');
  xlabel('Zeit in s');    grid on;
  La = axis;   axis([t(nd(1)), t(nd(end)), La(3:4)]);
subplot(313), plot(t(nd), 20*im(nd),t(nd),u_La(nd));
  title('Strom im*20 und Spannung uLa');
  xlabel('Zeit in s');  grid on;
  La = axis;   axis([t(nd(1)), t(nd(end)), 1.1*La(3:4)]);
% -------- Mittlere Leistungen
Pg = mean(i(1,:).*ug)         % Mittlere Leistung von der Quelle
Pv = mean((i(2,:).^2)*R21)    % Mittlere Leistung beim Verbraucher



