% Skript nichtlinear_L2.m in dem ein DC-DC Wandler
% mit nichtlinearer Induktivitt und Glttungskapazitt
% simuliert wird

clear;
% -------- Nichtlineare Magnetisierungskennlinie
fluss_m = [-0.65 -0.6 -0.5 -0.2 0 0.2 0.5 0.6 0.65]/5;
i_m = [-17 -10 -5 -1.5 0 1.5 5 10 17]/20;
a = polyfit(fluss_m, i_m, 7);       % Nichtlineare Kennlinie

fluss = (-0.15:0.01:0.15);       % Bereich fuer die Darstellung
i = polyval(a, fluss);

figure(1);   clf;
plot(i,fluss);
title('Magnetisierungskennlinie');
xlabel('i in A');     grid on;
ylabel('Fluss in Wb');
hold on;
plot(i_m, fluss_m, '*');
hold off

% ----- Parameter der Schaltung
RL = 0.05;       R = 10;
C = 100e-6;

% ------- Numerisches Integrationsverfahren
f = 10000;    T = 1/f;
dt = 1e-1/f;
t = 0:dt:600*T;
% Anregung
ampl = 10;
ug = (ampl*sign(sin(2*pi*f*t-pi/4)) + ampl)/2;
nt = length(t);

% Initialisierungen
fluss = zeros(1,nt);
fluss(1) = 0;   % Anfangsfluss
fluss_temp = fluss(1);
uc = zeros(1,nt);
uc(1) = 0;
uc_temp = uc(1);
iL = zeros(1,nt);
iL(1) = polyval(a, fluss_temp);
iL_temp = iL(1);
ni = 2;       % Anzahl der internen Rekursionen
dti = dt/ni;
for k = 1:nt-1;
    for p = 1:ni
        fluss_temp = fluss_temp + dti*(ug(k) - RL*iL_temp - uc_temp);
        uc_temp = uc_temp + dti*(iL_temp - uc_temp/R)/C;
        iL_temp = polyval(a, fluss_temp);
    end;
    fluss(k+1) = fluss_temp;
    uc(k+1) = uc_temp;
    iL(k+1) = iL_temp;
end;


figure(2);    clf;
subplot(311), plot(t, ug);
title('Eingangsspannung');
xlabel('Zeit in s');   grid on;
La = axis;   axis([La(1:3), La(4)*1.2]);

subplot(312), plot(t, iL); 
title(['Strom der Induktivitaet ']);
xlabel('Zeit in s');   grid on;

subplot(313), plot(t, uc); 
title(['Spannung der Kapazitaet ']);
xlabel('Zeit in s');   grid on;
