% Skript nichtlinear_L1.m in dem eine Reihenschaltung mit
% Widerstand und Induktor mit nichtlinearer Magnetisierungs-
% kennlinie simuliert wird

clear;
% -------- Nichtlineare Magnetisierungskennlinie
fluss_m = [-0.8 -0.7 -0.5 -0.2 0 0.2 0.5 0.7 0.8];
i_m = [-17 -10 -3.75 -1.2 0 1.2 3.75 10 17];

a = polyfit(fluss_m,i_m, 5); % Annaeherung mit Polynom 5 Grades
fluss = -0.8:0.01:0.8;       % Bereich fuer die Darstellung
i = polyval(a, fluss);       % Nichtlineare Kennlinie

figure(1);   clf;
plot(i,fluss);
title('Magnetisierungskennlinie');
xlabel('i in A');     grid on;
ylabel('Fluss in Wb');
hold on;
plot(i_m, fluss_m, '*');
hold off;

% Die entsprechende nichtlineare Induktivitaet
Li = diff(fluss)./diff(i);
figure(2);   clf;
plot(i(1:end-1), Li)
title('Nichtlineare Induktivitaet');
xlabel('Strom in A');    grid on; 
ylabel('H');

% -------- Anregungsspannung
R = 10;                   % Reihenwiderstand
u_ampl = 230*sqrt(2);     % Amplitude der Anregung
%u_ampl = 100*sqrt(2);
f = 50;             phi0 = 0;
Tfinal = 10/f;      dt = 0.5e-2/f;
t = 0:dt:Tfinal;    nt = length(t);

ug = u_ampl*cos(2*pi*f*t + phi0);

% -------- Numerische Loesung mit Euler-Verfahren
fluss = zeros(1,nt);
fluss(1) = 0.8;   % Anfangsfluss
%fluss(1) = 0;   % Anfangsfluss
fluss_temp = fluss(1);
ni = 10;       % Anzahl der internen Rekursionen
dti = dt/ni;
for k =1:nt-1
    for p = 1:ni
        fluss_temp = fluss_temp + dti*(ug(k) - polyval(a, fluss_temp)*R);
    end;    
    fluss(k+1) = fluss_temp;
end;
iL = polyval(a, fluss);    % Strom aus Fluss

figure(3);     clf;
subplot(311), plot(t, ug);
title('Anregungsspannung');
xlabel('Zeit in s');   grid on;

subplot(312), plot(t, fluss);
title('Magnetischer Fluss');
xlabel('Zeit in s');   grid on;

subplot(313), plot(t, iL);
title('Strom');
xlabel('Zeit in s');   grid on;

% -------- Amplitudenstpektrum des Stroms
iL_neu = iL.*hamming(nt)';
Ifft = abs(fft(iL_neu))/sum(hamming(nt));
fmax = 1000;
nf = fix(nt*fmax*dt);

figure(4);    clf;
plot((0:nf-1)/(nt*dt), 20*log10(Ifft(1:nf)));
title('Amplitudenspektrum (FFT/N)');
xlabel('Hz');   grid on;

% Amplitude der Grundwelle
fmax = 100;
nf = fix(nt*fmax*dt);
i_ampl = 2*max(Ifft(1:nf))





